class Pickup_Crate extends UniversalSoldiersPickup;

#exec Texture Import File=Textures\CrateTexture.bmp Name=CrateTexture Group=Pickups MIPS=ON LODSET=2

#exec obj load file=..\Textures\Indus5.utx package=Indus5

#exec mesh import mesh=USCrate anivfile=Models\USCrate_a.3d datafile=Models\USCrate_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=USCrate x=0 y=0 z=0
#exec mesh sequence mesh=USCrate seq=All startframe=0 numframes=1

#exec meshmap new meshmap=USCrate mesh=USCrate
#exec meshmap scale meshmap=USCrate x=0.0625 y=0.0625 z=0.125

event float BotDesireability(Pawn Bot)
{

	return (0); 

}

auto state Pickup
{	
	function Touch( actor Other )
	{
		local US_PRI IPRI;
		local int D;
		local vector X;

		if ( ValidTouch(Other) && Other.IsA('PlayerPawn')) 
			{
			D = Rand(4);
			//Money Crate:
			if ( D == 0 )
				{
				US_PRI(PlayerPawn(Other).PlayerReplicationInfo).Money += 25;
				PlayerPawn(Other).ClientMessage("Woot! The crate contained 25$");
				}
			//Health Crate:
			if ( D == 1 )
				{
				PlayerPawn(Other).Health += 100;
				PlayerPawn(Other).ClientMessage("Woot! The crate contained 100 healthpoints!");
				}
			//Statpoint Crate:
			if ( D == 2 )
				{
				US_PRI(PlayerPawn(Other).PlayerReplicationInfo).StatPoints += 1;
				PlayerPawn(Other).ClientMessage("Woot! The crate contained a statpoint!");
				}
			//Joltet Crate:
			if ( D == 3 )
				{
				Other.TakeDamage(1000,Pawn(Other),Pawn(Other).Location, 60000 * X, 'joltet');
				spawn(class'UT_SpriteBallExplosion',,,Self.Location);
				PlayerPawn(Other).ClientMessage("Bummer! The crate was a trap!");
				}

			PlaySound (PickupSound,,2.5);
			PlayPickupMessage(PlayerPawn(Other));
			Other.MakeNoise(0.2);		
			SetRespawn();	
			}
	

	}
	function BeginState()
	{

		SetTimer(1.0,True);
	
	}
}


defaultproperties
{
LifeTime=15
DrawType=DT_Mesh
Mesh=Mesh'USCrate'
CollisionRadius=16
CollisionHeight=16
MultiSkins(0)=Texture'CrateTexture'
MultiSkins(1)=Texture'Indus5.Galleon.ShpWood4'
PickupMessage=""
ItemName="Crate"
RespawnTime=0.000000
PickupViewMesh=Mesh'USCrate'
PickupSound=Sound'UnrealShare.Generic.RespawnSound'
ScaleGlow=2.000000
bCollideWhenPlacing=True
bBounce=True
}
